/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hop.ui.core.widget.highlight;

import java.io.IOException;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.hop.core.util.Utils;
import org.apache.hop.ui.core.PropsUi;
import org.apache.hop.ui.core.gui.GuiResource;
import org.apache.hop.ui.core.widget.highlight.StyleAttribute;
import org.eclipse.swt.custom.LineStyleEvent;
import org.eclipse.swt.custom.LineStyleListener;
import org.eclipse.swt.custom.StyleRange;
import org.eclipse.swt.custom.StyledText;

public class JavaScriptHighlight
implements LineStyleListener {
    JavaScanner scanner;
    StyleAttribute[] styleAttributes;
    ArrayList<int[]> blockComments = new ArrayList();
    public static final int EOF = -1;
    public static final int EOL = 10;
    public static final int WORD = 0;
    public static final int WHITE = 1;
    public static final int KEY = 2;
    public static final int COMMENT = 3;
    public static final int SYMBOL = 4;
    public static final int STRING = 5;
    public static final int OTHER = 6;
    public static final int NUMBER = 7;
    public static final int FUNCTION = 8;
    public static final int MAXIMUM_TOKEN = 9;

    public JavaScriptHighlight() {
        this(List.of());
    }

    public JavaScriptHighlight(List<String> functionNames) {
        this.initializeStyles();
        this.scanner = new JavaScanner(functionNames);
    }

    StyleAttribute getStyleAttribute(int type) {
        if (type < 0 || type >= this.styleAttributes.length) {
            return null;
        }
        return this.styleAttributes[type];
    }

    boolean inBlockComment(int start, int end) {
        for (int i = 0; i < this.blockComments.size(); ++i) {
            int[] offsets = this.blockComments.get(i);
            if (offsets[0] >= start && offsets[0] <= end) {
                return true;
            }
            if (offsets[1] >= start && offsets[1] <= end) {
                return true;
            }
            if (offsets[0] > start || offsets[1] < end) continue;
            return true;
        }
        return false;
    }

    void initializeStyles() {
        GuiResource resource = GuiResource.getInstance();
        this.styleAttributes = new StyleAttribute[9];
        this.styleAttributes[0] = new StyleAttribute(resource.getColorBlack(), 0);
        this.styleAttributes[1] = new StyleAttribute(resource.getColorBlack(), 0);
        this.styleAttributes[5] = new StyleAttribute(resource.getColorDarkGreen(), 0);
        this.styleAttributes[6] = new StyleAttribute(resource.getColorBlack(), 0);
        this.styleAttributes[7] = new StyleAttribute(resource.getColorOrange(), 0);
        if (PropsUi.getInstance().isDarkMode()) {
            this.styleAttributes[3] = new StyleAttribute(resource.getColorGray(), 2);
            this.styleAttributes[2] = new StyleAttribute(resource.getColor(30, 144, 255), 0);
            this.styleAttributes[4] = new StyleAttribute(resource.getColor(243, 126, 131), 0);
            this.styleAttributes[8] = new StyleAttribute(resource.getColor(177, 102, 218), 0);
        } else {
            this.styleAttributes[3] = new StyleAttribute(resource.getColorDarkGray(), 2);
            this.styleAttributes[2] = new StyleAttribute(resource.getColorBlue(), 0);
            this.styleAttributes[4] = new StyleAttribute(resource.getColorDarkRed(), 0);
            this.styleAttributes[8] = new StyleAttribute(resource.getColor(148, 0, 211), 0);
        }
    }

    public void lineGetStyle(LineStyleEvent event) {
        ArrayList<StyleRange> styles = new ArrayList<StyleRange>();
        if (this.inBlockComment(event.lineOffset, event.lineOffset + event.lineText.length())) {
            StyleAttribute attribute = this.getStyleAttribute(3);
            styles.add(new StyleRange(event.lineOffset, event.lineText.length() + 4, attribute.getForeground(), null, attribute.getStyle()));
            event.styles = styles.toArray(new StyleRange[styles.size()]);
            return;
        }
        this.scanner.setRange(event.lineText);
        String xs = ((StyledText)event.widget).getText();
        if (xs != null) {
            this.parseBlockComments(xs);
        }
        int token = this.scanner.nextToken();
        while (token != -1) {
            if (token != 6) {
                if (token == 1 && !styles.isEmpty()) {
                    int start = this.scanner.getStartOffset() + event.lineOffset;
                    lastStyle = (StyleRange)styles.get(styles.size() - 1);
                    if (lastStyle.fontStyle != 0 && lastStyle.start + lastStyle.length == start) {
                        lastStyle.length += this.scanner.getLength();
                    }
                } else {
                    StyleAttribute attribute = this.getStyleAttribute(token);
                    if (attribute != this.styleAttributes[0]) {
                        StyleRange style = new StyleRange(this.scanner.getStartOffset() + event.lineOffset, this.scanner.getLength(), attribute.getForeground(), null, attribute.getStyle());
                        if (token == 2) {
                            style.fontStyle = 1;
                        }
                        if (styles.isEmpty()) {
                            styles.add(style);
                        } else {
                            lastStyle = (StyleRange)styles.get(styles.size() - 1);
                            if (lastStyle.similarTo(style) && lastStyle.start + lastStyle.length == style.start) {
                                lastStyle.length += style.length;
                            } else {
                                styles.add(style);
                            }
                        }
                    }
                }
            }
            token = this.scanner.nextToken();
        }
        event.styles = styles.toArray(new StyleRange[styles.size()]);
    }

    public void parseBlockComments(String text) {
        this.blockComments = new ArrayList();
        StringReader buffer = new StringReader(text);
        boolean blkComment = false;
        int cnt = 0;
        int[] offsets = new int[2];
        boolean done = false;
        try {
            block7: while (!done) {
                int ch = buffer.read();
                switch (ch) {
                    case -1: {
                        if (blkComment) {
                            offsets[1] = cnt;
                            this.blockComments.add(offsets);
                        }
                        done = true;
                        continue block7;
                    }
                    case 47: {
                        ch = buffer.read();
                        if (ch == 42 && !blkComment) {
                            offsets = new int[2];
                            offsets[0] = cnt++;
                            blkComment = true;
                        } else {
                            ++cnt;
                        }
                        ++cnt;
                        continue block7;
                    }
                    case 42: {
                        if (blkComment) {
                            ch = buffer.read();
                            ++cnt;
                            if (ch == 47) {
                                blkComment = false;
                                offsets[1] = cnt;
                                this.blockComments.add(offsets);
                            }
                        }
                        ++cnt;
                        continue block7;
                    }
                }
                ++cnt;
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public class JavaScanner {
        protected Map<String, Integer> reserved = new HashMap<String, Integer>();
        protected StringBuilder fBuffer = new StringBuilder();
        protected String fDoc;
        protected int fPos;
        protected int fEnd;
        protected int fStartToken;
        protected boolean fEofSeen = false;
        private static final List<String> KEYWORDS = List.of("array", "break", "case", "catch", "const", "continue", "Date", "default", "delete", "do", "else", "eval", "escape", "false", "finally", "float", "for", "function", "if", "in", "instanceof", "isFinite", "isNaN", "new", "Number", "null", "String", "switch", "this", "then", "throw", "to", "true", "try", "typeof", "parseInt", "parseFloat", "return", "unescape", "var", "void", "with", "while");

        public JavaScanner(List<String> functionNames) {
            this.addKeywords(KEYWORDS);
            this.addFunctionNames(functionNames);
        }

        public void addKeywords(List<String> reservedKeywords) {
            if (Utils.isEmpty(reservedKeywords)) {
                return;
            }
            reservedKeywords.forEach(name -> this.reserved.put((String)name, 2));
        }

        public void addFunctionNames(List<String> functionNames) {
            if (Utils.isEmpty(functionNames)) {
                return;
            }
            functionNames.forEach(name -> this.reserved.put((String)name, 8));
        }

        public final int getLength() {
            return this.fPos - this.fStartToken;
        }

        public final int getStartOffset() {
            return this.fStartToken;
        }

        public int nextToken() {
            this.fStartToken = this.fPos;
            int c = this.read();
            switch (c) {
                case -1: {
                    return -1;
                }
                case 47: {
                    c = this.read();
                    if (c == 47) {
                        while ((c = this.read()) != -1 && c != 10) {
                        }
                        this.unread(c);
                        return 3;
                    }
                    return 4;
                }
                case 39: {
                    block19: while (true) {
                        c = this.read();
                        switch (c) {
                            case 39: {
                                return 5;
                            }
                            case -1: {
                                this.unread(c);
                                return 5;
                            }
                            case 92: {
                                c = this.read();
                                continue block19;
                            }
                        }
                    }
                }
                case 34: {
                    block20: while (true) {
                        c = this.read();
                        switch (c) {
                            case 34: {
                                return 5;
                            }
                            case -1: {
                                this.unread(c);
                                return 5;
                            }
                            case 92: {
                                c = this.read();
                                continue block20;
                            }
                        }
                    }
                }
                case 33: 
                case 38: 
                case 40: 
                case 41: 
                case 42: 
                case 43: 
                case 44: 
                case 45: 
                case 46: 
                case 58: 
                case 59: 
                case 60: 
                case 61: 
                case 62: 
                case 91: 
                case 93: 
                case 94: 
                case 123: 
                case 124: 
                case 125: {
                    return 4;
                }
                case 48: 
                case 49: 
                case 50: 
                case 51: 
                case 52: 
                case 53: 
                case 54: 
                case 55: 
                case 56: 
                case 57: {
                    while (Character.isDigit((char)(c = this.read()))) {
                    }
                    this.unread(c);
                    return 7;
                }
            }
            if (Character.isWhitespace((char)c)) {
                while (Character.isWhitespace((char)(c = this.read()))) {
                }
                this.unread(c);
                return 1;
            }
            if (Character.isJavaIdentifierStart((char)c)) {
                this.fBuffer.setLength(0);
                do {
                    this.fBuffer.append((char)c);
                } while (Character.isJavaIdentifierPart((char)(c = this.read())));
                this.unread(c);
                Integer token = this.reserved.get(this.fBuffer.toString());
                if (token != null) {
                    return token;
                }
                return 0;
            }
            return 6;
        }

        protected int read() {
            if (this.fPos <= this.fEnd) {
                return this.fDoc.charAt(this.fPos++);
            }
            return -1;
        }

        public void setRange(String text) {
            this.fDoc = text;
            this.fPos = 0;
            this.fEnd = this.fDoc.length() - 1;
        }

        protected void unread(int c) {
            if (c != -1) {
                --this.fPos;
            }
        }
    }
}

