/*
 * Decompiled with CFR 0.152.
 */
package org.antlr.gunit.swingui.model;

import java.io.File;
import java.util.ArrayList;
import java.util.List;
import org.antlr.gunit.swingui.model.Rule;
import org.antlr.runtime.CommonTokenStream;

public class TestSuite {
    protected List<Rule> rules;
    protected String grammarName;
    protected CommonTokenStream tokens;
    protected File testSuiteFile;

    protected TestSuite(String gname, File testFile) {
        this.grammarName = gname;
        this.testSuiteFile = testFile;
        this.rules = new ArrayList<Rule>();
    }

    public File getTestSuiteFile() {
        return this.testSuiteFile;
    }

    public void addRule(Rule currentRule) {
        if (currentRule == null) {
            throw new IllegalArgumentException("Null rule");
        }
        this.rules.add(currentRule);
    }

    public boolean hasRule(Rule rule) {
        for (Rule r : this.rules) {
            if (!r.getName().equals(rule.getName())) continue;
            return true;
        }
        return false;
    }

    public int getRuleCount() {
        return this.rules.size();
    }

    public void setRules(List<Rule> newRules) {
        this.rules.clear();
        this.rules.addAll(newRules);
    }

    public void setGrammarName(String name) {
        this.grammarName = name;
    }

    public String getGrammarName() {
        return this.grammarName;
    }

    public Rule getRule(int index) {
        return this.rules.get(index);
    }

    public CommonTokenStream getTokens() {
        return this.tokens;
    }

    public void setTokens(CommonTokenStream ts) {
        this.tokens = ts;
    }

    public Rule getRule(String name) {
        for (Rule rule : this.rules) {
            if (!rule.getName().equals(name)) continue;
            return rule;
        }
        return null;
    }

    public List<Rule> getRulesForStringTemplate() {
        return this.rules;
    }
}

