/*
 * Decompiled with CFR 0.152.
 */
package org.apache.datasketches.memory.internal;

import java.lang.foreign.Arena;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import org.apache.datasketches.memory.Buffer;
import org.apache.datasketches.memory.Memory;
import org.apache.datasketches.memory.MemoryRequestServer;
import org.apache.datasketches.memory.Resource;
import org.apache.datasketches.memory.WritableBuffer;
import org.apache.datasketches.memory.WritableMemory;
import org.apache.datasketches.memory.internal.ResourceImpl;
import org.testng.Assert;
import org.testng.annotations.Test;

public class NativeWritableBufferImplTest {
    private static final MemoryRequestServer memReqSvr = Resource.defaultMemReqSvr;

    @Test
    public void checkNativeCapacityAndClose() throws Exception {
        int memCapacity = 64;
        WritableMemory wmem = WritableMemory.allocateDirect((long)memCapacity, (long)1L, (ByteOrder)ByteOrder.nativeOrder(), (MemoryRequestServer)memReqSvr, (Arena)Arena.ofConfined());
        WritableBuffer wbuf = wmem.asWritableBuffer();
        Assert.assertEquals((long)wbuf.getCapacity(), (long)memCapacity);
        wmem.getArena().close();
        Assert.assertFalse((boolean)wbuf.isAlive());
        try {
            wmem.getArena().close();
        }
        catch (IllegalStateException illegalStateException) {
            // empty catch block
        }
    }

    @Test
    public void checkPutGetBooleans() {
        int i;
        int i2;
        boolean[] srcArray = new boolean[]{true, false, true, false, false, true, false, true};
        int len = srcArray.length;
        int half = len / 2;
        WritableBuffer wbuf = WritableMemory.allocate((int)len, (ByteOrder)ResourceImpl.NATIVE_BYTE_ORDER).asWritableBuffer();
        for (i2 = 0; i2 < half; ++i2) {
            wbuf.putBoolean(srcArray[i2]);
        }
        for (i2 = half; i2 < len; ++i2) {
            wbuf.putBoolean((long)i2, srcArray[i2]);
        }
        wbuf.resetPosition();
        boolean[] dstArray = new boolean[len];
        for (i = 0; i < half; ++i) {
            dstArray[i] = wbuf.getBoolean();
        }
        for (i = half; i < len; ++i) {
            dstArray[i] = wbuf.getBoolean((long)i);
        }
        Assert.assertEquals((boolean[])srcArray, (boolean[])dstArray);
    }

    @Test
    public void checkPutGetBytes() {
        byte[] srcArray = new byte[]{1, -2, 3, -4, 5, -6, 7, -8};
        int len = srcArray.length;
        int half = len / 2;
        WritableBuffer wbuf = WritableMemory.allocate((int)len, (ByteOrder)ResourceImpl.NATIVE_BYTE_ORDER).asWritableBuffer();
        wbuf.putByte(srcArray[0]);
        wbuf.putByteArray(srcArray, 1, 2);
        wbuf.putByte(srcArray[3]);
        for (int i = half; i < len; ++i) {
            wbuf.putByte((long)i, srcArray[i]);
        }
        wbuf.resetPosition();
        byte[] dstArray = new byte[len];
        dstArray[0] = wbuf.getByte();
        wbuf.getByteArray(dstArray, 1, 2);
        dstArray[3] = wbuf.getByte();
        for (int i = half; i < len; ++i) {
            dstArray[i] = wbuf.getByte((long)i);
        }
        Assert.assertEquals((byte[])srcArray, (byte[])dstArray);
    }

    @Test
    public void checkPutGetNativeCharacters() {
        char[] srcArray = new char[]{'a', 'b', 'c', 'd', 'e', 'f', 'g', 'h'};
        int len = srcArray.length;
        int half = len / 2;
        WritableBuffer wbuf = WritableMemory.allocate((int)(len * 2), (ByteOrder)ResourceImpl.NATIVE_BYTE_ORDER).asWritableBuffer();
        wbuf.putChar(srcArray[0]);
        wbuf.putCharArray(srcArray, 1, 2);
        wbuf.putChar(srcArray[3]);
        for (int i = half; i < len; ++i) {
            wbuf.putChar((long)(i * 2), srcArray[i]);
        }
        wbuf.resetPosition();
        char[] dstArray = new char[len];
        dstArray[0] = wbuf.getChar();
        wbuf.getCharArray(dstArray, 1, 2);
        dstArray[3] = wbuf.getChar();
        for (int i = half; i < len; ++i) {
            dstArray[i] = wbuf.getChar((long)(i * 2));
        }
        Assert.assertEquals((char[])srcArray, (char[])dstArray);
    }

    @Test
    public void checkPutGetNativeDoubles() {
        double[] srcArray = new double[]{1.0, 2.0, 3.0, 4.0, 5.0, 6.0, 7.0, 8.0};
        int len = srcArray.length;
        int half = len / 2;
        WritableBuffer wbuf = WritableMemory.allocate((int)(len * 8), (ByteOrder)ResourceImpl.NATIVE_BYTE_ORDER).asWritableBuffer();
        wbuf.putDouble(srcArray[0]);
        wbuf.putDoubleArray(srcArray, 1, 2);
        wbuf.putDouble(srcArray[3]);
        for (int i = half; i < len; ++i) {
            wbuf.putDouble((long)(i * 8), srcArray[i]);
        }
        wbuf.resetPosition();
        double[] dstArray = new double[len];
        dstArray[0] = wbuf.getDouble();
        wbuf.getDoubleArray(dstArray, 1, 2);
        dstArray[3] = wbuf.getDouble();
        for (int i = half; i < len; ++i) {
            dstArray[i] = wbuf.getDouble((long)(i * 8));
        }
        Assert.assertEquals((double[])srcArray, (double[])dstArray);
    }

    @Test
    public void checkPutGetNativeFloats() {
        float[] srcArray = new float[]{1.0f, 2.0f, 3.0f, 4.0f, 5.0f, 6.0f, 7.0f, 8.0f};
        int len = srcArray.length;
        int half = len / 2;
        WritableBuffer wbuf = WritableMemory.allocate((int)(len * 4), (ByteOrder)ResourceImpl.NATIVE_BYTE_ORDER).asWritableBuffer();
        wbuf.putFloat(srcArray[0]);
        wbuf.putFloatArray(srcArray, 1, 2);
        wbuf.putFloat(srcArray[3]);
        for (int i = half; i < len; ++i) {
            wbuf.putFloat((long)(i * 4), srcArray[i]);
        }
        wbuf.resetPosition();
        float[] dstArray = new float[len];
        dstArray[0] = wbuf.getFloat();
        wbuf.getFloatArray(dstArray, 1, 2);
        dstArray[3] = wbuf.getFloat();
        for (int i = half; i < len; ++i) {
            dstArray[i] = wbuf.getFloat((long)(i * 4));
        }
        Assert.assertEquals((float[])srcArray, (float[])dstArray);
    }

    @Test
    public void checkPutGetNativeInts() {
        int[] srcArray = new int[]{1, 2, 3, 4, 5, 6, 7, 8};
        int len = srcArray.length;
        int half = len / 2;
        WritableBuffer wbuf = WritableMemory.allocate((int)(len * 4), (ByteOrder)ResourceImpl.NATIVE_BYTE_ORDER).asWritableBuffer();
        wbuf.putInt(srcArray[0]);
        wbuf.putIntArray(srcArray, 1, 2);
        wbuf.putInt(srcArray[3]);
        for (int i = half; i < len; ++i) {
            wbuf.putInt((long)(i * 4), srcArray[i]);
        }
        wbuf.resetPosition();
        int[] dstArray = new int[len];
        dstArray[0] = wbuf.getInt();
        wbuf.getIntArray(dstArray, 1, 2);
        dstArray[3] = wbuf.getInt();
        for (int i = half; i < len; ++i) {
            dstArray[i] = wbuf.getInt((long)(i * 4));
        }
        Assert.assertEquals((int[])srcArray, (int[])dstArray);
    }

    @Test
    public void checkPutGetNativeLongs() {
        long[] srcArray = new long[]{1L, 2L, 3L, 4L, 5L, 6L, 7L, 8L};
        int len = srcArray.length;
        int half = len / 2;
        WritableBuffer wbuf = WritableMemory.allocate((int)(len * 8), (ByteOrder)ResourceImpl.NATIVE_BYTE_ORDER).asWritableBuffer();
        wbuf.putLong(srcArray[0]);
        wbuf.putLongArray(srcArray, 1, 2);
        wbuf.putLong(srcArray[3]);
        for (int i = half; i < len; ++i) {
            wbuf.putLong((long)(i * 8), srcArray[i]);
        }
        wbuf.resetPosition();
        long[] dstArray = new long[len];
        dstArray[0] = wbuf.getLong();
        wbuf.getLongArray(dstArray, 1, 2);
        dstArray[3] = wbuf.getLong();
        for (int i = half; i < len; ++i) {
            dstArray[i] = wbuf.getLong((long)(i * 8));
        }
        Assert.assertEquals((long[])srcArray, (long[])dstArray);
    }

    @Test
    public void checkPutGetNativeShorts() {
        short[] srcArray = new short[]{1, 2, 3, 4, 5, 6, 7, 8};
        int len = srcArray.length;
        int half = len / 2;
        WritableBuffer wbuf = WritableMemory.allocate((int)(len * 2), (ByteOrder)ResourceImpl.NATIVE_BYTE_ORDER).asWritableBuffer();
        wbuf.putShort(srcArray[0]);
        wbuf.putShortArray(srcArray, 1, 2);
        wbuf.putShort(srcArray[3]);
        for (int i = half; i < len; ++i) {
            wbuf.putShort((long)(i * 2), srcArray[i]);
        }
        wbuf.resetPosition();
        short[] dstArray = new short[len];
        dstArray[0] = wbuf.getShort();
        wbuf.getShortArray(dstArray, 1, 2);
        dstArray[3] = wbuf.getShort();
        for (int i = half; i < len; ++i) {
            dstArray[i] = wbuf.getShort((long)(i * 2));
        }
        Assert.assertEquals((short[])srcArray, (short[])dstArray);
    }

    @Test
    public void checkNativeBaseBound() throws Exception {
        int memCapacity = 64;
        try (Arena arena = Arena.ofConfined();){
            WritableMemory wmem = WritableMemory.allocateDirect((long)memCapacity, (long)1L, (ByteOrder)ByteOrder.nativeOrder(), (MemoryRequestServer)memReqSvr, (Arena)arena);
            WritableBuffer wbuf = wmem.asWritableBuffer();
            wbuf.toString("Force Assertion Error", (long)memCapacity, 8, false);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void checkNativeSrcArrayBound() throws Exception {
        long memCapacity = 64L;
        try (Arena arena = Arena.ofConfined();){
            WritableMemory wmem = WritableMemory.allocateDirect((long)memCapacity, (long)1L, (ByteOrder)ByteOrder.nativeOrder(), (MemoryRequestServer)memReqSvr, (Arena)arena);
            WritableBuffer wbuf = wmem.asWritableBuffer();
            byte[] srcArray = new byte[]{1, -2, 3, -4};
            wbuf.putByteArray(srcArray, 0, 5);
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            // empty catch block
        }
    }

    @Test(expectedExceptions={IndexOutOfBoundsException.class})
    public void checkRegionBounds() throws Exception {
        int memCapacity = 64;
        try (Arena arena = Arena.ofConfined();){
            WritableMemory wmem = WritableMemory.allocateDirect((long)memCapacity, (long)1L, (ByteOrder)ByteOrder.nativeOrder(), (MemoryRequestServer)memReqSvr, (Arena)arena);
            WritableBuffer wbuf = wmem.asWritableBuffer();
            wbuf.writableRegion(1L, 64L, wbuf.getTypeByteOrder());
        }
    }

    @Test
    public void checkByteBufferWrap() {
        int memCapacity = 64;
        ByteBuffer byteBuf = ByteBuffer.allocate(memCapacity);
        byteBuf.order(ByteOrder.nativeOrder());
        for (int i = 0; i < memCapacity; ++i) {
            byteBuf.put(i, (byte)i);
        }
        WritableBuffer wbuf = WritableBuffer.writableWrap((ByteBuffer)byteBuf);
        for (int i = 0; i < memCapacity; ++i) {
            Assert.assertEquals((byte)wbuf.getByte(), (byte)byteBuf.get(i));
        }
        Assert.assertTrue((boolean)wbuf.hasByteBuffer());
        ByteBuffer byteBuf2 = wbuf.toByteBuffer(ByteOrder.nativeOrder());
        Assert.assertEquals((Object)byteBuf2, (Object)byteBuf);
    }

    @Test
    public void checkWrapWithBBReadonly1() {
        int memCapacity = 64;
        ByteBuffer byteBuf = ByteBuffer.allocate(memCapacity);
        byteBuf.order(ByteOrder.nativeOrder());
        for (int i = 0; i < memCapacity; ++i) {
            byteBuf.put(i, (byte)i);
        }
        WritableBuffer buf = WritableBuffer.writableWrap((ByteBuffer)byteBuf);
        for (int i = 0; i < memCapacity; ++i) {
            Assert.assertEquals((byte)buf.getByte(), (byte)byteBuf.get(i));
        }
    }

    @Test(expectedExceptions={IllegalArgumentException.class})
    public void checkWrapWithBBReadonly2() {
        int memCapacity = 64;
        ByteBuffer byteBuf = ByteBuffer.allocate(memCapacity);
        byteBuf.order(ByteOrder.nativeOrder());
        ByteBuffer byteBufRO = byteBuf.asReadOnlyBuffer();
        byteBufRO.order(ByteOrder.nativeOrder());
        Assert.assertTrue((boolean)true);
        WritableBuffer wbuf = WritableBuffer.writableWrap((ByteBuffer)byteBufRO);
        Assert.assertTrue((boolean)wbuf.isReadOnly());
    }

    @Test
    public void checkWrapWithDirectBBReadonly() {
        int memCapacity = 64;
        ByteBuffer byteBuf = ByteBuffer.allocateDirect(memCapacity);
        byteBuf.order(ByteOrder.nativeOrder());
        for (int i = 0; i < memCapacity; ++i) {
            byteBuf.put(i, (byte)i);
        }
        ByteBuffer byteBufRO = byteBuf.asReadOnlyBuffer();
        byteBufRO.order(ByteOrder.nativeOrder());
        Buffer buf = Buffer.wrap((ByteBuffer)byteBufRO);
        for (int i = 0; i < memCapacity; ++i) {
            Assert.assertEquals((byte)buf.getByte(), (byte)byteBuf.get(i));
        }
    }

    @Test(expectedExceptions={IllegalArgumentException.class})
    public void checkWrapWithDirectBBReadonlyPut() {
        int memCapacity = 64;
        ByteBuffer byteBuf = ByteBuffer.allocateDirect(memCapacity);
        ByteBuffer byteBufRO = byteBuf.asReadOnlyBuffer();
        byteBufRO.order(ByteOrder.nativeOrder());
        WritableBuffer.writableWrap((ByteBuffer)byteBufRO);
    }

    @Test
    public void checkByteBufferWrapDirectAccess() {
        int memCapacity = 64;
        ByteBuffer byteBuf = ByteBuffer.allocateDirect(memCapacity);
        byteBuf.order(ByteOrder.nativeOrder());
        for (int i = 0; i < memCapacity; ++i) {
            byteBuf.put(i, (byte)i);
        }
        Buffer buf = Buffer.wrap((ByteBuffer)byteBuf);
        for (int i = 0; i < memCapacity; ++i) {
            Assert.assertEquals((byte)buf.getByte(), (byte)byteBuf.get(i));
        }
    }

    @Test
    public void checkIsDirect() throws Exception {
        int memCapacity = 64;
        WritableBuffer mem = WritableMemory.allocate((int)memCapacity).asWritableBuffer();
        Assert.assertFalse((boolean)mem.isDirect());
        try (Arena arena = Arena.ofConfined();){
            WritableMemory wmem = WritableMemory.allocateDirect((long)memCapacity, (long)1L, (ByteOrder)ByteOrder.nativeOrder(), (MemoryRequestServer)memReqSvr, (Arena)arena);
            WritableBuffer wbuf = wmem.asWritableBuffer();
            Assert.assertTrue((boolean)wbuf.isDirect());
        }
    }

    @Test
    public void checkIsReadOnly() {
        long[] srcArray = new long[]{1L, -2L, 3L, -4L, 5L, -6L, 7L, -8L};
        WritableBuffer wbuf = WritableMemory.writableWrap((long[])srcArray).asWritableBuffer();
        Assert.assertFalse((boolean)wbuf.isReadOnly());
        WritableBuffer buf = wbuf;
        Assert.assertFalse((boolean)buf.isReadOnly());
        for (int i = 0; i < srcArray.length; ++i) {
            Assert.assertEquals((long)buf.getLong(), (long)srcArray[i]);
        }
    }

    @Test
    public void checkGoodBounds() {
        ResourceImpl.checkBounds((long)50L, (long)50L, (long)100L);
    }

    @Test
    public void checkAsBuffer() {
        WritableMemory wmem = WritableMemory.allocate((int)64);
        WritableBuffer wbuf = wmem.asWritableBuffer();
        wbuf.setPosition(32L);
        for (int i = 32; i < 64; ++i) {
            wbuf.putByte((byte)i);
        }
        Buffer buf = wmem.asBuffer();
        buf.setPosition(32L);
        for (int i = 32; i < 64; ++i) {
            Assert.assertEquals((int)buf.getByte(), (int)i);
        }
    }

    @Test
    public void checkDuplicate() {
        WritableMemory wmem = WritableMemory.allocate((int)64);
        for (int i = 0; i < 64; ++i) {
            wmem.putByte((long)i, (byte)i);
        }
        WritableBuffer wbuf = wmem.asWritableBuffer().writableDuplicate();
        for (int i = 0; i < 64; ++i) {
            Assert.assertEquals((int)wbuf.getByte(), (int)i);
        }
        Buffer buf = wmem.asBuffer().duplicate();
        for (int i = 0; i < 64; ++i) {
            Assert.assertEquals((int)buf.getByte(), (int)i);
        }
        WritableMemory wmem2 = wbuf.asWritableMemory();
        for (int i = 0; i < 64; ++i) {
            Assert.assertEquals((int)wmem2.getByte((long)i), (int)i);
        }
        wbuf.asWritableMemory();
    }

    @Test
    public void checkDegenerateRegionReturn() {
        Memory mem = Memory.wrap((byte[])new byte[0]);
        Buffer buf = mem.asBuffer();
        Buffer reg = buf.region();
        Assert.assertEquals((long)reg.getCapacity(), (long)0L);
    }

    @Test
    public void checkAsWritableMemoryRO() {
        ByteBuffer bb = ByteBuffer.allocate(64);
        WritableBuffer wbuf = WritableBuffer.writableWrap((ByteBuffer)bb);
        try {
            Buffer buf = Buffer.wrap((ByteBuffer)bb.asReadOnlyBuffer());
            wbuf = (WritableBuffer)buf;
            wbuf.asWritableMemory();
            Assert.fail();
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void checkWritableDuplicateRO() {
        ByteBuffer bb = ByteBuffer.allocate(64);
        WritableBuffer wbuf = WritableBuffer.writableWrap((ByteBuffer)bb);
        try {
            Buffer buf = Buffer.wrap((ByteBuffer)bb);
            wbuf = (WritableBuffer)buf;
            wbuf.writableDuplicate();
            Assert.fail();
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void checkWritableRegionRO() {
        ByteBuffer bb = ByteBuffer.allocate(64);
        WritableBuffer wbuf = WritableBuffer.writableWrap((ByteBuffer)bb);
        try {
            Buffer buf = Buffer.wrap((ByteBuffer)bb);
            wbuf = (WritableBuffer)buf;
            wbuf.writableRegion();
            Assert.fail();
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void checkWritableRegionWithParamsRO() {
        ByteBuffer bb = ByteBuffer.allocate(64);
        WritableBuffer wbuf = WritableBuffer.writableWrap((ByteBuffer)bb);
        try {
            Buffer buf = Buffer.wrap((ByteBuffer)bb);
            wbuf = (WritableBuffer)buf;
            wbuf.writableRegion(0L, 1L, wbuf.getTypeByteOrder());
            Assert.fail();
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void checkZeroBuffer() {
        WritableMemory wmem = WritableMemory.allocate((int)8);
        WritableBuffer wbuf = wmem.asWritableBuffer();
        WritableBuffer reg = wbuf.writableRegion(0L, 0L, wbuf.getTypeByteOrder());
        Assert.assertEquals((long)reg.getCapacity(), (long)0L);
    }

    @Test
    public void checkDuplicateNonNative() {
        WritableMemory wmem = WritableMemory.allocate((int)64);
        wmem.putShort(0L, (short)1);
        Buffer buf = wmem.asWritableBuffer().duplicate(ResourceImpl.NON_NATIVE_BYTE_ORDER);
        Assert.assertEquals((int)buf.getShort(0L), (int)256);
    }

    @Test
    public void printlnTest() {
        NativeWritableBufferImplTest.println("PRINTING: " + this.getClass().getName());
    }

    static void println(String s) {
    }
}

